<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\User;
use App\Models\Customer;
use App\Models\Bill;
use App\Models\BillProcess;
use App\Models\Collection;
use Illuminate\Support\Facades\Http;
use Carbon\Carbon;
use DB;

class HomeController extends Controller
{

    public function __construct()
    {
        $this->middleware('auth');
    }

    public function index()
    {

        $userCount = User::count();
        $customerCount = Customer::count();
        $billCount = Bill::count();
        $approvedBillCount = Bill::where('delete_flag', 0)->where('approval', 1)->count();
        $rejectedBillCount = Bill::where('delete_flag', 0)->where('approval', 3)->count();
        $approvedBillCount = 0;
        $rejectedBillCount = 0;
        $activeBillCount = Bill::where('delete_flag', 0)->where('approval', 1)->where('status', 'Active')->count();
        $inactiveBillCount = Bill::where('delete_flag', 0)->where('approval', 1)->where('status', 'Inactive')->count();
        $invoiceCount = BillProcess::where('delete_flag', 0)->distinct('invoice_no')->count();
        // $collectionCount = Collection::count();
        $collectionCount = 0;
        $invoices = BillProcess::where('delete_flag', 0)->latest()->limit(5)->get();
        $collectionAmount = Collection::where('delete_flag', 0)->latest()->limit(3)->get();
        $paidInvoiceCount = BillProcess::where('delete_flag', 0)->where('payment_status', 'Paid')->count();
        $unpaidInvoiceCount = BillProcess::where('delete_flag', 0)->where('payment_status', 'Unpaid')->count();
        $partialPaidInvoiceCount = BillProcess::where('delete_flag', 0)->where('payment_status', 'Partial Paid')->count();
        $totalInvoices = $paidInvoiceCount + $unpaidInvoiceCount + $partialPaidInvoiceCount;
        $paidInvoicePercentage = $totalInvoices > 0 ? ($paidInvoiceCount / $totalInvoices) * 100 : 0;
        $unpaidInvoicePercentage = $totalInvoices > 0 ? ($unpaidInvoiceCount / $totalInvoices) * 100 : 0;
        $partialPaidInvoicePercentage = $totalInvoices > 0 ? ($partialPaidInvoiceCount / $totalInvoices) * 100 : 0;
        $invoiceStats = [
            'paidPercentage' => sprintf('%.2f', $paidInvoicePercentage),
            'unpaidPercentage' => sprintf('%.2f', $unpaidInvoicePercentage),
            'partialPaidPercentage' => sprintf('%.2f', $partialPaidInvoicePercentage),
        ];
        $today = \Carbon\Carbon::today();
        $collections = [];
        for ($i = 0; $i < 30; $i++) {
            $date = $today->copy()->subDays($i)->format('d/m/Y');
            // $totalAmount = Collection::where('coll_date', $date)->where('delete_flag', 0)
            //     ->sum('total_coll_amount');

            $totalAmount = Collection::where('coll_date', $date)
                ->where('delete_flag', 0)
                ->selectRaw('SUM(total_coll_amount) as total')
                ->value('total');

            $collections[] = [
                'date' => $date,
                'amount' => $totalAmount,
            ];
        }
        $collections = array_reverse($collections);

        // Current month collection amount
        $startOfMonth = Carbon::now()->startOfMonth();
        $endOfMonth = Carbon::now()->endOfMonth();
        $month = now()->format('m'); $year = now()->format('Y');
        $collectionsAmt = Collection::select('coll_date','total_coll_amount')
            ->where('coll_date', 'like', "%/$month/$year")->where('delete_flag', 0)->get();
        $monthCollectionAmount = $collectionsAmt->filter(function ($item) use ($startOfMonth, $endOfMonth) {
            $date = Carbon::createFromFormat('d/m/Y', $item->coll_date);
            return $date->between($startOfMonth, $endOfMonth);
        })
        ->sum(function ($item) {
            return (float) $item->total_coll_amount;
        });

        return view('dashboard.dashboard', compact(
            'userCount', 'customerCount', 'billCount', 'invoiceCount', 'collectionCount',
             'invoiceStats', 'collections', 'invoices', 'collectionAmount','monthCollectionAmount',
            'approvedBillCount', 'rejectedBillCount','activeBillCount' ,'inactiveBillCount'
        ));
    }

}
