<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Department;
use Illuminate\Support\Facades\Validator;

class DepartmentController extends Controller
{
    // public function index()
    // {
    //     if (!auth()->user()->can('Manage Setup')) {
    //         abort(403, 'Sorry !! You are not authorized!');
    //     }
        

    //     $departments = Department::all();
    //     return view('department.index', compact('departments'));
    // }

    public function index(Request $request)
    {
        if (!auth()->user()->can('Manage Setup')) {
            abort(403, 'Sorry !! You are not authorized!');
        }
    
        $perPage = $request->input('per_page', 25);
    
        $departments = Department::paginate($perPage);
    
        return view('department.index', compact('departments', 'perPage'));
    }
    

    public function create()
    {
        if (!auth()->user()->can('Manage Setup')) {
            abort(403, 'Sorry !! You are not authorized!');
        }
        

        return view('department.create');
    }

    public function store(Request $request)
    {
        if (!auth()->user()->can('Manage Setup')) {
            abort(403, 'Sorry !! You are not authorized!');
        }
        

        $validator = Validator::make($request->all(), [
            'department_name' => 'required',
        ]);
    
        if ($validator->fails()) {
            return redirect()->route('department.index')
                         ->with('error', 'Missing required fields.');
        }

        Department::create($request->all());

        return redirect()->route('department.index')
                         ->with('success', 'Department created successfully.');
                         
    }

    public function edit(Department $department)
    {
        if (!auth()->user()->can('Manage Setup')) {
            abort(403, 'Sorry !! You are not authorized!');
        }
        

        return view('department.edit', compact('department'));
    }

    public function update(Request $request, Department $department)
    {
        if (!auth()->user()->can('Manage Setup')) {
            abort(403, 'Sorry !! You are not authorized!');
        }
        

        $validator = Validator::make($request->all(), [
            'department_name' => 'required',
        ]);
    
        if ($validator->fails()) {
            return redirect()->route('department.index')
                         ->with('error', 'Missing required fields.');
        }

        $department->update($request->all());

        return redirect()->route('department.index')
                         ->with('success', 'Department updated successfully.');
    }

    public function destroy(Department $department)
    {
        if (!auth()->user()->can('Manage Setup')) {
            abort(403, 'Sorry !! You are not authorized!');
        }
        
        
        $department->delete();

        return redirect()->route('department.index')
                         ->with('success', 'Department deleted successfully.');
    }
}
