<?php

namespace App\Http\Controllers;

use App\Models\GlHead;
use App\Models\Customer;
use App\Models\Settings;
use Illuminate\Http\Request;
use App\Models\AdvancedCustomer;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Validator;

class CustomersAdvanced extends Controller
{

    // public function index()
    // {

    //     $advancedcustomers = AdvancedCustomer::all();
    //     $customerheadIds = $advancedcustomers->pluck('customerhead_id')->toArray();
    //     $advancedCustomername = DB::table('billing_customers')->whereIn('id', $customerheadIds)->pluck('customer_name', 'id')->toArray();

    //     return view('advanced-customer.index', compact('advancedcustomers', 'advancedCustomername'));
    // }



    public function index(Request $request)
    {

        if (!auth()->user()->can('Manage Setup')) {
            abort(403, 'Sorry !! You are not authorized!');
        }

        $perPage = $request->input('per_page', 25);

        $advancedcustomers = AdvancedCustomer::orderBy('id', 'desc')->paginate($perPage);
        $customerheadIds = $advancedcustomers->pluck('customerhead_id')->toArray();

        // Fetch customer names
        $advancedCustomername = DB::table('billing_customers')
            ->whereIn('id', $customerheadIds)
            ->pluck('customer_name', 'id')
            ->toArray();

        // Fetch advanced customer head names (similar to 'create' method)
        $token = session('api_token');
        $api_ip = env("API_IP");
        $company_number = env("COMPANY_NUMBER");

        $getAdvancedHead = GlHead::where('gl_subject', strtoupper('Advance, Deposits & Prepayments'))->first();
        $advancedCustomerHeadNames = [];

        if ($getAdvancedHead) {
            $glCodeCusadvanced = $getAdvancedHead->gl_code;

            try {
                $response2 = Http::withHeaders([
                    'Authorization' => 'Bearer ' . $token,
                ])->get($api_ip . '/api/v1/integrate/searchByGroupCode', [
                    'groupCode' => $glCodeCusadvanced,
                    'companyNo' => $company_number,
                ]);

                if ($response2->successful()) {
                    $responseData2 = $response2->json();
                    if ($responseData2 && isset($responseData2['accHeadDetailsInfos'])) {
                        $advancedCustomerHeadNames = collect($responseData2['accHeadDetailsInfos'])
                            ->pluck('udAcName', 'autoAcNo')
                            ->toArray();
                    }
                }
            } catch (\Exception $e) {
                // Handle exception
            }
        }

        return view('advanced-customer.index', compact('advancedcustomers', 'advancedCustomername', 'advancedCustomerHeadNames', 'perPage'));
    }





    public function create()
    {


        $advancedcustomers = [];
        $customers = Customer::where('status','Active')->orderBy('customer_name', 'asc')->get();

        $token = session('api_token');
        $api_ip = env("API_IP");
        $company_number = env("COMPANY_NUMBER");

        $getAdvancedHead = GlHead::where('gl_subject',strtoupper('Advance, Deposits & Prepayments'))->first();
        if($getAdvancedHead){
            $glCodeCusadvanced = $getAdvancedHead->gl_code;


            try{
                $response2 = Http::withHeaders([
                    'Authorization' => 'Bearer ' . $token,
                ])->get($api_ip.'/api/v1/integrate/searchByGroupCode', [
                    'groupCode' => $glCodeCusadvanced,
                    'companyNo' => $company_number,
                ]);

                if ($response2->successful()) {
                    $responseData2 = $response2->json();
                    if ($responseData2 && isset($responseData2['accHeadDetailsInfos'])) {
                        $advancedcustomers = $responseData2['accHeadDetailsInfos'];
                    }
                }
            }catch (\Exception $e) {
                // Log::error($e->getMessage());
            }
        }

       return view('advanced-customer.create', compact('customers', 'advancedcustomers'));
    }


    public function store(Request $request)
    {
        // dd($request->all());

        $validator = Validator::make($request->all(), [
            'customer_head' => 'required',
            'customeradvanced_head' => 'required',

        ]);

        if ($validator->fails()) {
            return redirect()->route('advancedcustomer.create')
                ->with('error', 'Missing required fields.');
        }

        $fndCustomer = Customer::where('autoAcNo', $request->customer_head)->first();
        if ($fndCustomer) {
            $custPKID = $fndCustomer->id;
            $autoAcNo = $fndCustomer->autoAcNo;
        }

        $data = [
            'customerhead_id' => $custPKID,
            'customerhead_autoAcNo' => $autoAcNo,
            'customeradvancedhead_autoAcNo' => $request->customeradvanced_head
        ];

        AdvancedCustomer::create($data);

        return redirect()->back()->with('success', 'Advanced Customer Created Successfully.');
    }

    public function edit($id)
    {
        $advancedCustomerall = AdvancedCustomer::findOrFail($id);

        $advancedcustomers = [];
        $customers = Customer::where('status','Active')->orderBy('customer_name', 'asc')->get();

        $token = session('api_token');
        $api_ip = env("API_IP");
        $company_number = env("COMPANY_NUMBER");

        $getAdvancedHead = GlHead::where('gl_subject', strtoupper('Advance, Deposits & Prepayments'))->first();
        if ($getAdvancedHead) {
            $glCodeCusadvanced = $getAdvancedHead->gl_code;

            try {
                $response2 = Http::withHeaders([
                    'Authorization' => 'Bearer ' . $token,
                ])->get($api_ip.'/api/v1/integrate/searchByGroupCode', [
                    'groupCode' => $glCodeCusadvanced,
                    'companyNo' => $company_number,
                ]);

                if ($response2->successful()) {
                    $responseData2 = $response2->json();
                    if ($responseData2 && isset($responseData2['accHeadDetailsInfos'])) {
                        $advancedcustomers = $responseData2['accHeadDetailsInfos'];
                    }
                }
            } catch (\Exception $e) {
                // Log::error($e->getMessage());
            }
        }


        return view('advanced-customer.edit', compact('advancedCustomerall', 'customers', 'advancedcustomers'));
    }

    public function update(Request $request, $id)
    {
        $validator = Validator::make($request->all(), [
            'customer_head' => 'required',
            'customeradvanced_head' => 'required',
        ]);

        if ($validator->fails()) {
            return redirect()->route('advancedcustomer.edit', $id)
                ->with('error', 'Missing required fields.');
        }

        $advancedCustomer = AdvancedCustomer::findOrFail($id);

        $fndCustomer = Customer::where('autoAcNo', $request->customer_head)->first();
        if ($fndCustomer) {
            $custPKID = $fndCustomer->id;
            $autoAcNo = $fndCustomer->autoAcNo;
        }

        $data = [
            'customerhead_id' => $custPKID,
            'customerhead_autoAcNo' => $autoAcNo,
            'customeradvancedhead_autoAcNo' => $request->customeradvanced_head
        ];

        $advancedCustomer->update($data);

        return redirect()->route('advancedcustomer.index')->with('success', 'Advanced Customer Updated Successfully.');
    }



    public function delete($id)
    {
        $advancedCustomer = AdvancedCustomer::findOrFail($id);

        $isCustomerInAdvancedCollections = DB::table('advanced_collections')
            ->where('customer', $advancedCustomer->customerhead_id)
            ->exists();

        if ($isCustomerInAdvancedCollections) {
            return redirect()->back()->with('error', 'This customer already has an advanced collection.');
        }

        $advancedCustomer->delete();

        return redirect()->back()->with('success', 'Advanced Customer deleted successfully.');
    }





}
