<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\CustomerBank;
use App\Models\Customer;
use Illuminate\Support\Facades\Validator;

class CustomerBankController extends Controller
{
    // public function index()
    // {
    //     if (!auth()->user()->can('Manage Setup')) {
    //         abort(403, 'Sorry !! You are not authorized!');
    //     }
        
        
    //     $customerBanks = CustomerBank::all();
    //     return view('customerBank.index', compact('customerBanks'));
    // }


    public function index(Request $request)
    {
        if (!auth()->user()->can('Manage Setup')) {
            abort(403, 'Sorry !! You are not authorized!');
        }
        
        $perPage = $request->input('per_page', 25);
        
        $customerBanks = CustomerBank::paginate($perPage);
        
        return view('customerBank.index', compact('customerBanks', 'perPage'));
    }


    public function create()
    {
        if (!auth()->user()->can('Manage Setup')) {
            abort(403, 'Sorry !! You are not authorized!');
        }
        

        $customers = Customer::select('id', 'customer_name')->get();
        return view('customerBank.create',compact('customers'));
    }

    public function store(Request $request)
    {
        if (!auth()->user()->can('Manage Setup')) {
            abort(403, 'Sorry !! You are not authorized!');
        }
        

        $validator = Validator::make($request->all(), [
            'customer_id' => 'required',
            'bank_id' => 'required',
            'bank_name' => 'required',
            'address' => 'required',
            'phone' => 'required',
            'email' => 'required|email',
        ]);
    
        if ($validator->fails()) {
            return redirect()->route('customer-bank.index')
                         ->with('error', 'Missing required fields.');
        }

        CustomerBank::create($request->all() + ['created_by' => auth()->id()]);

        return redirect()->route('customer-bank.index')
                         ->with('success', 'Customer Bank created successfully.');
    }

    public function edit(CustomerBank $customerBank)
    {
        if (!auth()->user()->can('Manage Setup')) {
            abort(403, 'Sorry !! You are not authorized!');
        }
        
        
        $customers = Customer::select('id', 'customer_name')->get();
        return view('customerBank.edit', compact('customerBank','customers'));
    }

    public function update(Request $request, CustomerBank $customerBank)
    {
        if (!auth()->user()->can('Manage Setup')) {
            abort(403, 'Sorry !! You are not authorized!');
        }
        

        $validator = Validator::make($request->all(), [
            'customer_id' => 'required',
            'bank_id' => 'required',
            'bank_name' => 'required',
            'address' => 'required',
            'phone' => 'required',
            'email' => 'required|email',
        ]);
    
        if ($validator->fails()) {
            return redirect()->route('customer-bank.index')
                         ->with('error', 'Missing required fields.');
        }

        $customerBank->update($request->all());

        return redirect()->route('customer-bank.index')
                         ->with('success', 'Customer Bank updated successfully.');
    }

    public function destroy(CustomerBank $customerBank)
    {
        if (!auth()->user()->can('Manage Setup')) {
            abort(403, 'Sorry !! You are not authorized!');
        }
        
        
        $customerBank->delete();

        return redirect()->route('customer-bank.index')
                         ->with('success', 'Customer Bank deleted successfully.');
    }
}
