<?php

namespace App\Http\Controllers;

use Illuminate\Support\Facades\Cache;

class CacheController extends Controller
{
    public function getHeaderScript()
    {
        return Cache::remember('header', 60, function () {
            return view('layouts.headerScript')->render();
        });
    }

    public function getFooterScript()
    {
        return Cache::remember('footer', 60, function () {
            return view('layouts.footerScript')->render();
        });
    }
}
