<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use Illuminate\Foundation\Auth\AuthenticatesUsers;
use Illuminate\Support\Facades\Http;
use Illuminate\Http\Request;

class LoginController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Login Controller
    |--------------------------------------------------------------------------
    |
    | This controller handles authenticating users for the application and
    | redirecting them to your home screen. The controller uses a trait
    | to conveniently provide its functionality to your applications.
    |
    */

    use AuthenticatesUsers;

    /**
     * Where to redirect users after login.
     *
     * @var string
     */
    protected $redirectTo = '/dashboard';

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('guest')->except('logout');
    }

    protected function authenticated(Request $request, $user)
    {
        $user_avatar = asset('images/user.png');
        $avatar = trim(auth()->user()->avatar);
        $avatarPath = 'storage/avatar/' . $avatar;
        if($avatar!='' && file_exists(public_path($avatarPath))){
            $user_avatar = asset($avatarPath);
        }
        session(['user_avatar' => $user_avatar]);

        // new line for bypass api login for testing
        // session(['api_token' => 111111]);

        // open bellow code for api login
        try {
            $api_ip = env('API_IP');
            $response = Http::post($api_ip.'/authenticate', [
                'userName' => $request->email,
                'password' => $request->password
            ]);

            if ($response->successful()) {
                $responseData = $response->json();
                if($responseData['login']=='success'){
                    session(['api_token' => $responseData['token']]);
                }
            }
        } catch (\Exception $e) {

        }

    }

}
