<?php

namespace App\Exports;

use App\Models\Customer;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Illuminate\Contracts\View\View;
use Maatwebsite\Excel\Concerns\FromView;

class CustomerBillSummaryExport implements FromView, ShouldAutoSize
{
    public function view(): View
    {
        $customers = Customer::all();

        $reportData=[];

        foreach ($customers as $customer) {
            $paidInvoices = $customer->invoices->filter(function ($invoice) {
                return $invoice->payment_status == 'Paid';
            });

            $unpaidInvoices = $customer->invoices->filter(function ($invoice) {
                return $invoice->payment_status == 'Unpaid';
            });

            $data=[
                'customer_id'=>$customer->id,
                'customer_name'=>$customer->customer_name,
                'total_bill'=>$customer->bills->count(),
                'paid_invoice'=>$paidInvoices->count(),
                'unpaid_invoice'=>$unpaidInvoices->count(),
                'paid_amount'=> $paidInvoices->sum('total_amount'),
                'unpaid_amount'=> $unpaidInvoices->sum('total_amount'),
            ];
            $reportData[]=$data;
        }

        return view('report.export.customer-bill-summary', [
            'data' => $reportData
        ]);
        }
        
    }


