<?php

namespace App\Exports;

use Illuminate\Contracts\View\View;
use Maatwebsite\Excel\Concerns\FromView;
use Maatwebsite\Excel\Concerns\WithStyles;
use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;

class BillIncreaseWarningExport implements FromView, WithStyles
{
    protected $request;

    public function __construct(Request $request)
    {
        $this->request = $request;
    }

    public function view(): View
    {
        $bills = [];
        $query = DB::table('billing_bills as b');

        $query->select([
            'b.ref_no',
            'b.ref_date',
            'c.customer_name',
            'b.particulars',
            'b.start_date',
            'b.end_date',
            'b.increase_past_date',
            'b.increase_start_date',
            'b.yearly_increase_percent',
            'b.increase_period',
            'b.bill_no_x as OLD_BILL_NO',
            'b.bill_group',
            'b.id as BILL_NO',
        ]);

        $query->leftJoin('billing_customers as c', 'b.customer_id', '=', 'c.id');

        $query->where('c.status', 'Active');
        $query->where('b.approval', 1);
        $query->where('b.delete_flag', 0);

        if ($this->request->filled('rpt_customer')) {
            $query->where('b.customer_id', $this->request->rpt_customer);
            $query->orderBy('b.id', 'asc');
        } else {
            $query->orderBy('c.customer_name', 'asc')
                ->orderBy('b.id', 'asc');
        }

        if ($this->request->filled('rpt_start_date')) {
            // b.increase_period MUST be > 0 (ignore null/blank/"0")
            $query->whereRaw("CAST(NULLIF(b.increase_period, '') AS UNSIGNED) > 0");
            $query->whereRaw(
                "STR_TO_DATE(b.increase_start_date, '%d/%m/%Y') <= STR_TO_DATE(?, '%d/%m/%Y')",
                [$this->request->rpt_start_date]
            );
            $bills = $query->get();
        }

        return view('report.export.bill-increase-warning-excel', [
            'bills'      => $bills,
            'customer'   => $this->request->rpt_customer,
            'start_date' => $this->request->rpt_start_date,
        ]);
    }

    public function styles(Worksheet $sheet)
    {
        return [
            1 => [ // First row (headings)
                'font' => [
                    'bold' => true,
                ],
            ],
        ];
    }
}
